/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.factory;

import io.sentry.DefaultSentryClientFactory;
import io.sentry.SentryClient;
import io.sentry.dsn.Dsn;
import io.sentry.event.helper.ContextBuilderHelper;
import io.sentry.event.helper.ForwardedAddressResolver;
import io.sentry.event.helper.HttpEventBuilderHelper;

public class QueueSentryClientFactory extends DefaultSentryClientFactory {
	/**
	 * Enable the ForwardedAddressResolver so we can see actual IPs in Sentry for TAM, which is hosted behind
	 * a proxy.
	 *
	 * See: https://docs.sentry.io/clients/java/config/#custom-functionality
	 *
	 * @param  dsn URI can be found in Sentry settings (given appropriate access).
	 * @return     a new Sentry Client.
	 */
	@Override
	public SentryClient createSentryClient(final Dsn dsn) {
		final SentryClient sentryClient = new SentryClient(createConnection(dsn), getContextManager(dsn));

		// Create and use the ForwardedAddressResolver, which will use the
		// X-FORWARDED-FOR header for the remote address if it exists.
		final ForwardedAddressResolver addressResolver = new ForwardedAddressResolver();
		sentryClient.addBuilderHelper(new HttpEventBuilderHelper(addressResolver));

		sentryClient.addBuilderHelper(new ContextBuilderHelper(sentryClient));
		return configureSentryClient(sentryClient, dsn);
	}
}
