/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import org.springframework.security.core.GrantedAuthority;

public enum DefaultRole implements GrantedAuthority {
	ROLE_STUDENT(
		"Student"
	),
	ROLE_TEACHER(
		"Teacher"
	),
	ROLE_ADMIN(
		"Admin"
	),
	ROLE_ASSISTANT(
		"Assistant"
	),
	ROLE_MANAGER(
		"Manager"
	);

	private final String displayName;

	DefaultRole(String displayName) {
		this.displayName = displayName;
	}

	public String getDisplayName() {
		return displayName;
	}

	@Override
	public String getAuthority() {
		return name();
	}

	public static DefaultRole valueOfExt(String role) throws UnknownRoleException {
		switch (role.toLowerCase()) {
			case "ta":
			case "assistant":
				return DefaultRole.ROLE_ASSISTANT;
			case "manager":
				return DefaultRole.ROLE_MANAGER;
			case "teacher":
				return DefaultRole.ROLE_TEACHER;
			case "admin":
				return DefaultRole.ROLE_ADMIN;
			case "student":
				return DefaultRole.ROLE_STUDENT;
			default:
				throw new UnknownRoleException("Unknown role: " + role);
		}
	}

	public static class UnknownRoleException extends Exception {
		public UnknownRoleException() {
		}

		public UnknownRoleException(String message) {
			super(message);
		}

		public UnknownRoleException(String message, Throwable cause) {
			super(message, cause);
		}
	}
}
