/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.*;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Entity class representing a cluster of students. The mentor group entity can only be edited by admins and
 * can be used in the creation of a lab to only selectively allow students to enrol for said lab.
 */
@Data
@NoArgsConstructor
@Entity
//@Where(clause = "active = 1")
public class FirstYearMentorGroup implements Serializable {
	private static final long serialVersionUID = 914713006211750100L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	/**
	 * The name of this mentor group to be displayed.
	 */
	@NotNull
	private String name;

	/**
	 * The students in this mentor group as found by their mentorGroup field.
	 */
	@OneToMany(mappedBy = "mentorGroup", cascade = { CascadeType.ALL })
	@Valid
	private List<FirstYearStudent> students = new ArrayList<>();

	/**
	 * Whether this mentor group is actively maintained.
	 */
	private boolean active = true;

	public FirstYearMentorGroup(String name) {
		this.name = name;
	}
}
