/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import java.io.Serializable;

import javax.annotation.Nullable;
import javax.persistence.*;

import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@Entity
public class FirstYearStudent implements Serializable {
	private static final long serialVersionUID = 516589986670791335L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	@ManyToOne
	@Nullable
	private User user;

	// TODO this seems to be actually student number at the moment?
	private String netId;

	@ManyToOne
	private FirstYearMentorGroup mentorGroup;

	public FirstYearStudent(User user, FirstYearMentorGroup mentorGroup) {
		this.user = user;
		this.mentorGroup = mentorGroup;
	}

	public FirstYearStudent(String netId, FirstYearMentorGroup mentorGroup) {
		this.netId = netId;
		this.mentorGroup = mentorGroup;
	}

	@Override
	public String toString() {
		if (user != null) {
			return "FirstYearStudent(netid=" + user.getUsername() + ", user=" + user.toString()
					+ ", mentorGroup=" + mentorGroup.getId() + ")";
		} else {
			return "FirstYearStudent(netid=" + this.netId + ", mentorGroup=" + mentorGroup.getId() + ")";
		}
	}
}
