/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name = "lab_group")
public class Group extends RequestEntity {

	/**
	 *
	 */
	private static final long serialVersionUID = 5164438526508141678L;

	@ManyToMany
	private List<User> members = new ArrayList<>();

	@ManyToOne
	private Course course;

	public Group() {
	}

	public Group(String displayName, Course course) {
		super(displayName);
		this.course = course;
	}

	public List<User> getMembers() {
		return members;
	}

	public void setMembers(List<User> members) {
		this.members = members;
	}

	public void addMember(User member) {
		if (!hasMember(member)) {
			members.add(member);
		}
	}

	public String membersToString() {
		StringBuilder returnString = new StringBuilder();
		for (User user : members) {
			returnString.append(user.getDisplayName()).append(", ");
		}
		return returnString.toString();
	}

	public Boolean hasMember(User member) {
		return members.stream().anyMatch(u -> u.equals(member));
	}

	public Course getCourse() {
		return course;
	}

	public void setCourse(Course course) {
		this.course = course;
	}
}
