/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import java.io.Serializable;
import java.time.LocalDateTime;

import javax.persistence.Entity;
import javax.persistence.OneToOne;

@Entity
public class LabSlot extends Slot implements Serializable {

	private static final long serialVersionUID = -6092888322533771698L;

	@OneToOne(mappedBy = "slot")
	private Lab lab;

	public LabSlot() {
	}

	public LabSlot(LocalDateTime opensAt, LocalDateTime closesAt) {
		super(opensAt, closesAt);
	}

	public Lab getLab() {
		return lab;
	}

	public void setLab(Lab lab) {
		this.lab = lab;

		if (!lab.getSlot().equals(this)) {
			lab.setSlot(this);
		}
	}

	@Override
	public String toString() {
		return "Slot{" +
				"id=" + this.getId() +
				", lab=" + lab +
				", opensAt=" + this.getOpensAt() +
				", closesAt=" + this.getClosesAt() +
				'}';
	}
}
