/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import java.util.*;
import java.util.stream.Collectors;

public class NotificationList extends LinkedList<Notification> {
	/**
	 *
	 */
	private static final long serialVersionUID = -1843421296570406343L;

	public NotificationList(List<Notification> list) {
		super(list);
	}

	public Set<Course> getCourses() {
		Map<Course, Boolean> seen = new HashMap<>();

		for (Notification notification : this) {
			seen.putIfAbsent(notification.getCourse(), Boolean.TRUE);
		}

		return seen.keySet();
	}

	public NotificationList forCourse(Course course) {
		List<Notification> notifications = stream()
				.filter(n -> n.getCourse().equals(course))
				.collect(Collectors.toList());

		return new NotificationList(notifications);
	}

	public Long unread() {
		return stream()
				.filter(Notification::isUnread)
				.count();
	}
}
