/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import java.time.LocalDateTime;

import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.validation.constraints.Size;

@Entity
public class RequestApprovedEvent extends RequestEvent {
	/**
	 *
	 */
	private static final long serialVersionUID = 992798464939565962L;

	private LocalDateTime approvedAt;

	@Size(max = 250)
	private String reason;

	@ManyToOne
	private User assistant;

	public RequestApprovedEvent() {
		super();
	}

	public RequestApprovedEvent(Request request, User assistant, LocalDateTime approvedAt, String reason) {
		super(request);

		this.approvedAt = approvedAt;
		this.assistant = assistant;
		this.reason = reason;
	}

	@Override
	public Request apply(Request request1) {
		return request1
				.setStatus(Request.Status.APPROVED)
				.setAssistant(assistant)
				.setApprovedAt(approvedAt)
				.setReason(reason);
	}

	@Override
	public LocalDateTime getTimestamp() {
		return approvedAt;
	}

	@Override
	public String getDescription() {
		return "Request approved";
	}

	@Override
	public String toString() {
		return "request-approved";
	}
}
