/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import java.io.Serializable;
import java.time.LocalDateTime;

import javax.persistence.*;

import nl.tudelft.ewi.queue.cqsr.Event;
import nl.tudelft.ewi.queue.views.View;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;

@Entity
@Inheritance(strategy = InheritanceType.SINGLE_TABLE)
@JsonIgnoreProperties({ "aggregate", "request" })
public abstract class RequestEvent implements Event<Request>, Serializable {

	private static final long serialVersionUID = 6344330279392287773L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@JsonView(View.Summary.class)
	protected Long id;

	@ManyToOne
	protected Request request;

	public RequestEvent() {
	}

	public RequestEvent(Request request) {
		this.request = request;
	}

	@Override
	public Request getAggregate() {
		return request;
	}

	/**
	 * Get textual description for this event
	 *
	 * @return
	 */
	@JsonView(View.Summary.class)
	public abstract String getDescription();

	/**
	 * Get the timestamp for this event
	 *
	 * @return
	 */
	@JsonView(View.Summary.class)
	public abstract LocalDateTime getTimestamp();
}
