/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import java.time.LocalDateTime;

import javax.persistence.Entity;
import javax.validation.constraints.Size;

@Entity
public class RequestForwardToAnyEvent extends RequestEvent {
	/**
	 *
	 */
	private static final long serialVersionUID = 3321677681535290268L;

	private LocalDateTime forwardedAt;

	@Size(max = 250)
	private String reason;

	public RequestForwardToAnyEvent() {
		super();
	}

	public RequestForwardToAnyEvent(Request request, LocalDateTime forwardedAt, String reason) {
		super(request);

		this.reason = reason;
		this.forwardedAt = forwardedAt;
	}

	@Override
	public Request apply(Request request1) {
		return request1
				.setStatus(Request.Status.PENDING)
				.setForwardedAt(forwardedAt)
				.setReason(reason);
	}

	@Override
	public LocalDateTime getTimestamp() {
		return forwardedAt;
	}

	@Override
	public String getDescription() {
		return "Request forwarded to anyone else" + "\n" + reason;
	}

	@Override
	public String toString() {
		return "request-forwarded-to-any";
	}
}
