/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import java.time.LocalDateTime;

import javax.persistence.Entity;

@Entity
public class RequestPickedEvent extends RequestEvent {
	/**
	 *
	 */
	private static final long serialVersionUID = -6845911533535937239L;
	protected LocalDateTime createdAt;

	public RequestPickedEvent() {
		super();
	}

	public RequestPickedEvent(Request request, LocalDateTime createdAt) {
		super(request);

		this.createdAt = createdAt;
		this.request.setStatus(Request.Status.PICKED);
	}

	@Override
	public Request apply(Request request1) {
		return request1
				.setStatus(Request.Status.PICKED)
				.setCreatedAt(createdAt);
	}

	@Override
	public LocalDateTime getTimestamp() {
		return createdAt;
	}

	@Override
	public String getDescription() {
		return "Request picked";
	}

	@Override
	public String toString() {
		return "request-picked";
	}
}
