/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import java.time.LocalDateTime;

import javax.persistence.Entity;

@Entity
public class RequestProcessingEvent extends RequestEvent {
	/**
	 *
	 */
	private static final long serialVersionUID = -5018900505348041016L;
	protected LocalDateTime processingAt;

	public RequestProcessingEvent() {
		super();
	}

	public RequestProcessingEvent(Request request, LocalDateTime processingAt) {
		super(request);
		this.processingAt = processingAt;
	}

	@Override
	public Request apply(Request request1) {
		return request1
				.setStatus(Request.Status.PROCESSING)
				.setProcessingAt(processingAt);
	}

	@Override
	public LocalDateTime getTimestamp() {
		return processingAt;
	}

	@Override
	public String getDescription() {
		return "Request processing";
	}

	@Override
	public String toString() {
		return "request-processing";
	}
}
