/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import java.time.LocalDateTime;

import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.validation.constraints.Size;

@Entity
public class RequestRejectedEvent extends RequestEvent {
	/**
	 *
	 */
	private static final long serialVersionUID = -6560217433195047238L;

	private LocalDateTime rejectedAt;

	@Size(max = 250)
	private String reason;

	@Size(max = 250)
	private String reasonForStudent;

	@ManyToOne
	private User assistant;

	public RequestRejectedEvent() {
		super();
	}

	public RequestRejectedEvent(Request request, User assistant, LocalDateTime rejectedAt,
			String reason, String reasonForStudent) {
		super(request);

		this.rejectedAt = rejectedAt;
		this.assistant = assistant;
		this.reason = reason;
		this.reasonForStudent = reasonForStudent;
	}

	@Override
	public Request apply(Request request1) {
		return request1
				.setStatus(Request.Status.REJECTED)
				.setRejectedAt(rejectedAt)
				.setAssistant(assistant)
				.setReason(reason)
				.setReasonForStudent(reasonForStudent);
	}

	@Override
	public LocalDateTime getTimestamp() {
		return rejectedAt;
	}

	@Override
	public String getDescription() {
		return "Request rejected";
	}

	@Override
	public String toString() {
		return "request-rejected";
	}

	public String getReasonForStudent() {
		return reasonForStudent;
	}

	public void setReasonForStudent(String reasonForStudent) {
		this.reasonForStudent = reasonForStudent;
	}
}
