/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

import nl.tudelft.ewi.queue.views.View;

import com.fasterxml.jackson.annotation.JsonView;

@Entity
public class RequestType implements Serializable {

	private static final long serialVersionUID = -7443377267531011238L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	@NotBlank
	@JsonView(View.Summary.class)
	@Size(max = 250)
	private String name;

	public RequestType(String name) {
		this.name = name;
	}

	public RequestType() {
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String toSentence(Request request, RequestEntity requestEntity, Assignment assignment) {
		String returnString = "";
		switch (name) {
			case "Question":
				returnString = "%s has a question about %s";
				break;
			case "Submission":
				returnString = "%s wants to submit %s";
				break;
		}

		if (request.getSlot() != null) {
			returnString += String.format(" at %s", request.getSlotSentence());
		}
		String displayName = requestEntity == null ? "" : requestEntity.getDisplayName();
		return String.format(returnString, displayName, assignment.getName());
	}

}
