/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import java.util.Collections;

public class UserPrincipal extends org.springframework.security.core.userdetails.User {
	/**
	 *
	 */
	private static final long serialVersionUID = -5816455445507659552L;
	private final User user;

	public UserPrincipal(User user) {
		super(user.getUsername(), user.getPassword(), Collections.singletonList(user.getDefaultRole()));

		this.user = user;
	}

	public User getUser() {
		return user;
	}
}
