/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.repository;

import java.util.List;

import javax.persistence.EntityNotFoundException;

import nl.tudelft.ewi.queue.model.Course;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.PagingAndSortingRepository;

import com.querydsl.core.types.Predicate;

public interface CourseRepository
		extends PagingAndSortingRepository<Course, Long>, QuerydslPredicateExecutor<Course> {

	/**
	 * Find all courses
	 *
	 * @return
	 */
	@Override
	List<Course> findAll();

	/**
	 * Find all courses for given pagination information
	 *
	 * @param  pageable
	 * @return
	 */
	@Override
	Page<Course> findAll(Pageable pageable);

	@Override
	Page<Course> findAll(Predicate predicate, Pageable pageable);

	/**
	 * Gets a course by its id from the course repository.
	 *
	 * @param  id                      The id to find a course by.
	 * @return                         The found course.
	 * @throws EntityNotFoundException If no course could be found with the given id.
	 */
	default Course findByIdOrThrow(Long id) {
		return findById(id).orElseThrow(() -> new EntityNotFoundException("Course was not found: " + id));
	}
}
