/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.repository;

import java.util.List;

import nl.tudelft.ewi.queue.model.FirstYearStudent;
import nl.tudelft.ewi.queue.model.User;

import org.springframework.data.repository.CrudRepository;

public interface FirstYearStudentRepository extends CrudRepository<FirstYearStudent, Long> {
	@Override
	List<FirstYearStudent> findAll();

	List<FirstYearStudent> findByUser(User user);

	List<FirstYearStudent> findByNetId(String netId);

	boolean existsByNetId(String netId);
}
