/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.repository;

import java.util.List;

import javax.persistence.EntityNotFoundException;

import nl.tudelft.ewi.queue.model.Lab;
import nl.tudelft.ewi.queue.model.QLab;

import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.CrudRepository;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;

public interface LabRepository extends CrudRepository<Lab, Long>, QuerydslPredicateExecutor<Lab> {
	@Override
	List<Lab> findAll();

	@Override
	Iterable<Lab> findAll(Predicate predicate);

	Lab findFirstByOrderByIdAsc();

	default Iterable<Lab> findAllByExamLabIsTrue(Predicate predicate) {
		QLab qLab = QLab.lab;
		BooleanExpression expression = qLab.examLab.isTrue().and(predicate);
		return findAll(expression);
	}

	default Lab findByIdOrThrow(Long id) {
		return findById(id).orElseThrow(() -> new EntityNotFoundException("Lab was not found: " + id));
	}
}
