/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.repository;

import java.util.List;

import javax.persistence.EntityNotFoundException;

import nl.tudelft.ewi.queue.model.Room;

import org.springframework.data.repository.CrudRepository;
import org.springframework.lang.NonNull;

public interface RoomRepository extends CrudRepository<Room, Long> {
	@Override
	@NonNull
	List<Room> findAll();

	Room findByName(String name);

	List<Room> findAllByOrderByNameAsc();

	/**
	 * Finds a Room by its ID and returns said Room. If no such Room could be found this method throws an
	 * EntityNotFoundException (404).
	 *
	 * @param  id The id of the Room to lookup.
	 * @return    The found Room with the given ID.
	 */
	default @NonNull Room findByIdOrThrow(Long id) {
		return findById(id).orElseThrow(() -> new EntityNotFoundException("Room was not found: " + id));
	}
}
