/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.service;

import nl.tudelft.ewi.queue.model.Request;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * A service for dealing with with Jitsi integration.
 */
@Service
public class JitsiService {

	@Value("${queue.jitsi.url}")
	private String jitsiURL;

	@Value("${queue.jitsi.protocol}")
	private String jitsiProtocol;

	/**
	 * Returns the Jitsi room URL for a specific request.
	 *
	 * @param  request the request
	 * @return         the URL to a Jitsi room linked with this request
	 */
	public String getJitsiRoomUrl(Request request) {
		if (request.getLab().isOnline()) {
			return jitsiProtocol + "://" + jitsiURL + "/" + request.getJitsiRoom();
		} else {
			return "";
		}
	}

}
