/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.viewmodel;

import java.util.ArrayList;
import java.util.List;

import lombok.Getter;
import lombok.Setter;
import nl.tudelft.ewi.queue.model.Assignment;
import nl.tudelft.ewi.queue.model.User;

@Getter
@Setter
public class AssignmentViewModel {

	private String name;
	private String assignmentID;
	private String verification;
	private boolean hasLab = false;
	private List<User> assistants = new ArrayList<>();

	public boolean hasLab() {
		return hasLab;
	}

	public boolean hasTA(User assistant) {
		return assistants.contains(assistant);
	}

	public static AssignmentViewModel convert(Assignment assignment) {
		AssignmentViewModel viewModel = new AssignmentViewModel();
		viewModel.name = assignment.getName();
		viewModel.assignmentID = assignment.getId().toString();
		viewModel.verification = assignment.getVerification();
		viewModel.assistants = assignment.getAssistants();
		if (assignment.getLabs().size() > 0) {
			viewModel.hasLab = true;
		}
		return viewModel;
	}

	public Assignment convertToNew() {
		Assignment assignment = new Assignment();
		assignment.setName(this.name);
		assignment.setAssistants(this.assistants);
		return assignment;
	}
}
