/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.csv;

import static org.assertj.core.api.Assertions.assertThat;
import static org.junit.jupiter.api.Assertions.assertThrows;

import java.io.IOException;
import java.util.List;

import org.junit.jupiter.api.Test;
import org.springframework.mock.web.MockMultipartFile;

public class FirstYearStudentCsvHelperTest {

	@Test
	public void testFirstCsvEntry() throws IOException, EmptyCsvException, InvalidCsvException {
		String csv = "Name,group\n" + "Mara,mentorgroup1";
		MockMultipartFile mock = new MockMultipartFile("test", csv.getBytes());
		List<FirstYearStudentCsvHelper> result = FirstYearStudentCsvHelper.readCsv(mock);
		assertThat(result.get(0).getNetId()).isEqualTo("Mara");
		assertThat(result.get(0).getMentorGroup()).isEqualTo("mentorgroup1");
	}

	@Test
	public void testEmptyCsv() {
		String csv = "";
		MockMultipartFile mock = new MockMultipartFile("test", csv.getBytes());

		assertThrows(EmptyCsvException.class, () -> {
			FirstYearStudentCsvHelper.readCsv(mock);
		});
	}

	@Test
	public void testTooManyDelimiters() {
		String csv = "Name,group\n" + "sa,asa,sa";
		MockMultipartFile mock = new MockMultipartFile("test", csv.getBytes());

		assertThrows(InvalidCsvException.class, () -> {
			FirstYearStudentCsvHelper.readCsv(mock);
		});
	}

}
