/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.csv;

import static org.assertj.core.api.Assertions.assertThat;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

import nl.tudelft.ewi.queue.model.Group;
import nl.tudelft.ewi.queue.model.Request;
import nl.tudelft.ewi.queue.model.RequestSlot;
import nl.tudelft.ewi.queue.model.User;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import com.fasterxml.jackson.core.JsonProcessingException;

public class LabCsvHelperTest {

	private LabCsvHelper labCsvHelper;

	@BeforeEach
	public void init() {
		labCsvHelper = new LabCsvHelper();
	}

	@Test
	public void serializeToCsvUser() throws JsonProcessingException {
		Request request = new Request();
		request.setCreatedAt(LocalDateTime.of(2020, 1, 1, 0, 0));
		request.setApprovedAt(LocalDateTime.of(2020, 1, 1, 1, 0));
		request.setSlot(
				new RequestSlot(LocalDateTime.of(2020, 1, 1, 1, 30), LocalDateTime.of(2020, 1, 1, 2, 0)));
		request.setRequestEntity(new User());
		request.setStatus(Request.Status.APPROVED);

		byte[] bytes = labCsvHelper.serializeToCsv(List.of(request));
		assertThat(Arrays.equals(bytes, new byte[] {
				34, 78, 101, 116, 32, 73, 68, 34, 44, 34, 67, 114, 101, 97, 116, 101, 100, 32, 97, 116, 34,
				44, 34, 72, 97, 110, 100, 108, 101, 100, 32, 97, 116, 34, 44, 34, 83, 108, 111, 116, 32, 115,
				116, 97, 114, 116, 115, 32, 97, 116, 34, 44, 34, 83, 108, 111, 116, 32, 101, 110, 100, 115,
				32, 97, 116, 34, 44, 83, 116, 97, 116, 117, 115, 44, 34, 84, 85, 32, 68, 101, 108, 102, 116,
				32, 81, 117, 101, 117, 101, 32, 85, 82, 76, 34, 10, 48, 44, 50, 48, 50, 48, 45, 48, 49, 45,
				48, 49, 84, 48, 48, 58, 48, 48, 44, 50, 48, 50, 48, 45, 48, 49, 45, 48, 49, 84, 48, 49, 58,
				48, 48, 44, 50, 48, 50, 48, 45, 48, 49, 45, 48, 49, 84, 48, 49, 58, 51, 48, 44, 50, 48, 50,
				48, 45, 48, 49, 45, 48, 49, 84, 48, 50, 58, 48, 48, 44, 65, 80, 80, 82, 79, 86, 69, 68, 44,
				34, 113, 117, 101, 117, 101, 46, 116, 117, 100, 101, 108, 102, 116, 46, 110, 108, 47, 114,
				101, 113, 117, 101, 115, 116, 47, 110, 117, 108, 108, 34, 10 })).isTrue();
	}

	@Test
	public void serializeToCsvGroup() throws JsonProcessingException {
		Request request = new Request();
		request.setCreatedAt(LocalDateTime.of(2020, 1, 1, 0, 0));
		request.setRequestEntity(new Group());
		request.setStatus(Request.Status.PENDING);

		byte[] bytes = labCsvHelper.serializeToCsv(List.of(request));
		assertThat(Arrays.equals(bytes, new byte[] {
				34, 78, 101, 116, 32, 73, 68, 34, 44, 34, 67, 114, 101, 97, 116, 101, 100, 32, 97, 116, 34,
				44, 34, 72, 97, 110, 100, 108, 101, 100, 32, 97, 116, 34, 44, 34, 83, 108, 111, 116, 32, 115,
				116, 97, 114, 116, 115, 32, 97, 116, 34, 44, 34, 83, 108, 111, 116, 32, 101, 110, 100, 115,
				32, 97, 116, 34, 44, 83, 116, 97, 116, 117, 115, 44, 34, 84, 85, 32, 68, 101, 108, 102, 116,
				32, 81, 117, 101, 117, 101, 32, 85, 82, 76, 34, 10, 44, 50, 48, 50, 48, 45, 48, 49, 45, 48,
				49, 84, 48, 48, 58, 48, 48, 44, 44, 44, 44, 80, 69, 78, 68, 73, 78, 71, 44, 34, 113, 117, 101,
				117, 101, 46, 116, 117, 100, 101, 108, 102, 116, 46, 110, 108, 47, 114, 101, 113, 117, 101,
				115, 116, 47, 110, 117, 108, 108, 34, 10 })).isTrue();
	}
}
