/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.dialect;

import static org.assertj.core.api.Assertions.assertThat;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;

import org.junit.jupiter.api.Test;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class FilterExpressionObjectFactoryTest {
	private FilterExpressionObjectFactory factory = new FilterExpressionObjectFactory();
	private FilterExpressionObjectFactory.Filter filter = (FilterExpressionObjectFactory.Filter) factory
			.buildObject(null, "filter");

	private MultiValueMap<String, String> emptyState = new LinkedMultiValueMap<>() {
		{
		}
	};

	private MultiValueMap<String, String> page1State = new LinkedMultiValueMap<>() {
		{
			add("page", "1");
		}
	};

	private MultiValueMap<String, String> page2AssignmentState = new LinkedMultiValueMap<>() {
		{
			add("page", "2");
			add("size", "1");
		}
	};

	private Collection<String> getQueryParams(String uri) {
		return Arrays.asList(URI.create(uri).getQuery().split("&"));
	}

	private Collection<String> listOf(String... args) {
		return Arrays.asList(args);
	}

	@Test
	public void buildingUrlShouldContainNoQueryParams() {
		assertThat(filter.buildUrlMultiValueMap(emptyState)).isEqualTo("?size&page");
	}

	@Test
	public void buildingUrlShouldContainSingleQueryParam() {
		assertThat(filter.buildUrlMultiValueMap(page1State)).isEqualTo("?size&page=1");
	}

	@Test
	public void buildingUrlShouldContainDifferentQueryParams() {
		String url = filter.buildUrlMultiValueMap(page2AssignmentState);
		assertThat(getQueryParams(url)).isEqualTo(listOf("size=1", "page=2"));
	}

	@Test
	public void buildingUrlShouldAcceptPaths() {
		assertThat(filter.buildUrlMultiValueMap(emptyState, "some/path")).isEqualTo("some/path?size&page");
	}

	@Test
	public void updateUrlShouldChangeExisting() {
		assertThat(filter.updateUrlMultiValueMap(page1State, "page", "2")).isEqualTo("?size&page=2");
	}
}
