/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import static org.assertj.core.api.Assertions.assertThat;

import java.util.List;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FirstYearMentorGroupTest {

	private FirstYearMentorGroup firstYearMentorGroup;
	private FirstYearMentorGroup other;

	@BeforeEach
	public void init() {
		firstYearMentorGroup = new FirstYearMentorGroup("mentor group");
		firstYearMentorGroup.setId(1L);
		other = new FirstYearMentorGroup("mentor group");
		other.setId(1L);
	}

	@Test
	public void equalsSameMentorGroup() {
		assertThat(firstYearMentorGroup.equals(firstYearMentorGroup)).isTrue();
	}

	@Test
	public void equalsOtherInstance() {
		assertThat(firstYearMentorGroup.equals(new Course())).isFalse();
	}

	@Test
	public void equalsThisIdNull() {
		firstYearMentorGroup.setId(null);
		assertThat(firstYearMentorGroup.equals(other)).isFalse();
	}

	@Test
	public void equalsBothIdNull() {
		firstYearMentorGroup.setId(null);
		other.setId(null);
		assertThat(firstYearMentorGroup.equals(other)).isTrue();
	}

	@Test
	public void equalsOtherId() {
		firstYearMentorGroup.setId(2L);
		assertThat(firstYearMentorGroup.equals(other)).isFalse();
	}

	@Test
	public void equalsThisNameNull() {
		firstYearMentorGroup.setName(null);
		assertThat(firstYearMentorGroup.equals(other)).isFalse();
	}

	@Test
	public void equalsBothNameNull() {
		firstYearMentorGroup.setName(null);
		other.setName(null);
		assertThat(firstYearMentorGroup.equals(other)).isTrue();
	}

	@Test
	public void equalsOtherName() {
		firstYearMentorGroup.setName("");
		assertThat(firstYearMentorGroup.equals(other)).isFalse();
	}

	@Test
	public void equalsThisStudentNull() {
		firstYearMentorGroup.setStudents(null);
		assertThat(firstYearMentorGroup.equals(other)).isFalse();
	}

	@Test
	public void equalsBothStudentNull() {
		firstYearMentorGroup.setStudents(null);
		other.setStudents(null);
		assertThat(firstYearMentorGroup.equals(other)).isTrue();
	}

	@Test
	public void equalsOtherStudent() {
		firstYearMentorGroup.setStudents(List.of(new FirstYearStudent()));
		assertThat(firstYearMentorGroup.equals(other)).isFalse();
	}

	@Test
	public void equalsOtherNonActive() {
		firstYearMentorGroup.setActive(false);
		assertThat(firstYearMentorGroup.equals(other)).isFalse();
	}

	@Test
	public void equalsSimple() {
		assertThat(firstYearMentorGroup.equals(other)).isTrue();
	}

	@Test
	public void hashCodeSimple() {
		assertThat(firstYearMentorGroup.hashCode()).isEqualTo(-1511017826);
	}

	@Test
	public void hashCodeIdNull() {
		firstYearMentorGroup.setId(null);
		assertThat(firstYearMentorGroup.hashCode()).isEqualTo(-1502391908);
	}

	@Test
	public void hashCodeNameNull() {
		firstYearMentorGroup.setName(null);
		assertThat(firstYearMentorGroup.hashCode()).isEqualTo(12472561);
	}

	@Test
	public void hashCodeStudentsNull() {
		firstYearMentorGroup.setStudents(null);
		assertThat(firstYearMentorGroup.hashCode()).isEqualTo(-1511015348);
	}

	@Test
	public void hashCodeNonActive() {
		firstYearMentorGroup.setActive(false);
		assertThat(firstYearMentorGroup.hashCode()).isEqualTo(-1511017808);
	}
}
