/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import static org.assertj.core.api.Assertions.assertThat;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FirstYearStudentTest {

	FirstYearStudent firstYearStudent;
	FirstYearStudent other;

	@BeforeEach
	public void init() {
		User user = new User();
		FirstYearMentorGroup firstYearMentorGroup = new FirstYearMentorGroup();

		firstYearStudent = new FirstYearStudent(user, firstYearMentorGroup);
		firstYearStudent.setId(1L);
		firstYearStudent.setNetId("netid");
		other = new FirstYearStudent(user, firstYearMentorGroup);
		other.setId(1L);
		other.setNetId("netid");
	}

	@Test
	public void equalsSameFirstYearStudent() {
		assertThat(firstYearStudent.equals(firstYearStudent)).isTrue();
	}

	@Test
	public void equalsOtherInstance() {
		assertThat(firstYearStudent.equals(new Course())).isFalse();
	}

	@Test
	public void equalsThisIdNull() {
		firstYearStudent.setId(null);
		assertThat(firstYearStudent.equals(other)).isFalse();
	}

	@Test
	public void equalsBothIdNull() {
		firstYearStudent.setId(null);
		other.setId(null);
		assertThat(firstYearStudent.equals(other)).isTrue();
	}

	@Test
	public void equalsDifferentId() {
		firstYearStudent.setId(2L);
		assertThat(firstYearStudent.equals(other)).isFalse();
	}

	@Test
	public void equalsThisUserNull() {
		firstYearStudent.setUser(null);
		assertThat(firstYearStudent.equals(other)).isFalse();
	}

	@Test
	public void equalsBothUserNull() {
		firstYearStudent.setUser(null);
		other.setUser(null);
		assertThat(firstYearStudent.equals(other)).isTrue();
	}

	@Test
	public void equalsDifferentUser() {
		User user = new User();
		user.id = 1L;
		firstYearStudent.setUser(user);
		assertThat(firstYearStudent.equals(other)).isFalse();
	}

	@Test
	public void equalsThisNetidNull() {
		firstYearStudent.setNetId(null);
		other.setNetId("");
		assertThat(firstYearStudent.equals(other)).isFalse();
	}

	@Test
	public void equalsBothNetidNull() {
		firstYearStudent.setNetId(null);
		other.setNetId(null);
		assertThat(firstYearStudent.equals(other)).isTrue();
	}

	@Test
	public void equalsDifferentNetid() {
		other.setNetId("other");
		assertThat(firstYearStudent.equals(other)).isFalse();
	}

	@Test
	public void equalsSameNetid() {
		assertThat(firstYearStudent.equals(other)).isTrue();
	}

	@Test
	public void equalsThisFirstYearMentorGroupNull() {
		firstYearStudent.setMentorGroup(null);
		assertThat(firstYearStudent.equals(other)).isFalse();
	}

	@Test
	public void equalsBothFirstYearMentorGroupNull() {
		firstYearStudent.setMentorGroup(null);
		other.setMentorGroup(null);
		assertThat(firstYearStudent.equals(other)).isTrue();
	}

	@Test
	public void equalsDifferentFirstYearMentorGroup() {
		FirstYearMentorGroup firstYearMentorGroup = new FirstYearMentorGroup();
		firstYearMentorGroup.setId(1L);
		firstYearStudent.setMentorGroup(firstYearMentorGroup);
		assertThat(firstYearStudent.equals(other)).isFalse();
	}

	@Test
	public void equalsSimple() {
		assertThat(firstYearStudent.equals(other)).isTrue();
	}

	@Test
	public void hashCodeSimple() {
		assertThat(firstYearStudent.hashCode()).isEqualTo(1919750052);
	}

	@Test
	public void hashCodeIdNull() {
		firstYearStudent.setId(null);
		assertThat(firstYearStudent.hashCode()).isEqualTo(1928375970);
	}

	@Test
	public void hashCodeUserNull() {
		firstYearStudent.setUser(null);
		assertThat(firstYearStudent.hashCode()).isEqualTo(1916554494);
	}

	@Test
	public void hashCodeNetidNull() {
		firstYearStudent.setNetId(null);
		assertThat(firstYearStudent.hashCode()).isEqualTo(36768997);
	}

	@Test
	public void hashCodeMentorGroupNull() {
		firstYearStudent.setMentorGroup(null);
		assertThat(firstYearStudent.hashCode()).isEqualTo(1898651616);
	}

	@Test
	public void toStringNoUser() {
		FirstYearStudent student = new FirstYearStudent("student", new FirstYearMentorGroup());
		assertThat(student.toString()).isEqualTo("FirstYearStudent(netid=student, mentorGroup=null)");
	}

	@Test
	public void toStringWithUser() {
		assertThat(firstYearStudent.toString())
				.isEqualTo("FirstYearStudent(netid=null, user=null, mentorGroup=null)");
	}
}
