/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import static org.assertj.core.api.Assertions.assertThat;

import java.util.ArrayList;
import java.util.List;

import nl.tudelft.ewi.queue.QueueApplication;
import nl.tudelft.ewi.queue.repository.CourseRepository;
import nl.tudelft.ewi.queue.repository.UserRepository;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.web.WebAppConfiguration;

@SpringBootTest(classes = QueueApplication.class)
@WebAppConfiguration
@AutoConfigureMockMvc
@DirtiesContext(classMode = DirtiesContext.ClassMode.BEFORE_CLASS)
public class GroupTest {

	Group group;

	User student;

	Course course;

	@Autowired
	CourseRepository courseRepository;

	@Autowired
	UserRepository userRepository;

	@BeforeEach
	public void setUp() {
		course = courseRepository.findById(1L).orElseThrow();
		group = new Group("Test Group", course);
		student = userRepository.findAll().get(0);
		group.addMember(student);
	}

	@Test
	public void testGetMembers() {
		List<User> members = group.getMembers();
		assertThat(members.size()).isEqualTo(1);

		User student2 = userRepository.findAll().get(1);
		group.addMember(student2);
		assertThat(members.size()).isEqualTo(2);
	}

	@Test
	public void testSetMembers() {
		group.setMembers(new ArrayList<>());
		assertThat(group.getMembers().size()).isZero();
	}

	@Test
	public void testAddMember() {
		User student2 = userRepository.findAll().get(1);
		group.addMember(student2);
		assertThat(group.getMembers().size()).isEqualTo(2);
	}

	@Test
	public void testAddMemberAlreadyAdded() {
		User student2 = userRepository.findAll().get(1);
		group.addMember(student2);
		group.addMember(student2);
		assertThat(group.getMembers().size()).isEqualTo(2);
	}

	@Test
	public void testMembersToString() {
		assertThat(group.membersToString()).isNotNull();
		assertThat(group.membersToString()).contains("student");
	}

	@Test
	public void testHasMember() {
		assertThat(group.hasMember(student)).isTrue();
	}

	@Test
	public void testGetCourse() {
		assertThat(group.getCourse()).isEqualTo(course);
	}

	@Test
	public void testSetCourse() {
		Course course = courseRepository.findAll().get(1);
		group.setCourse(course);
		assertThat(group.getCourse()).isEqualTo(course);
	}
}
