/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import static org.assertj.core.api.Assertions.assertThat;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NotificationTest {

	private Notification notification;
	private Notification other;

	@BeforeEach
	public void init() {
		notification = new Notification();
		notification.setId(1L);
		other = new Notification();
		other.setId(1L);
	}

	@Test
	public void equalsSameObject() {
		assertThat(notification.equals(notification)).isTrue();
	}

	@Test
	public void equalsNull() {
		assertThat(notification.equals(null)).isFalse();
	}

	@Test
	public void equalsOtherInstance() {
		assertThat(notification.equals(new Course())).isFalse();
	}

	@Test
	public void equalsDifferentId() {
		other.setId(2L);
		assertThat(notification.equals(null)).isFalse();
	}

	@Test
	public void equalsSameId() {
		assertThat(notification.equals(other)).isTrue();
	}

	@Test
	public void getUrlNull() {
		assertThat(notification.getUrl()).isEqualTo("/notification/1");
	}

	@Test
	public void getUrlNonNull() {
		notification.setUrl("/test/url/1");
		assertThat(notification.getUrl()).isEqualTo("/test/url/1");
	}

	@Test
	public void isUnreadTrue() {
		assertThat(notification.isUnread()).isTrue();
	}

	@Test
	public void isUnreadFalse() {
		notification.setRead(true);
		assertThat(notification.isUnread()).isFalse();
	}
}
