/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.model;

import static org.assertj.core.api.Assertions.assertThat;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RoomTest {

	private Room room;
	private Room other;

	@BeforeEach
	public void init() {
		room = new Room("name", false);
		room.setId(1L);
		room.setMapFilePath("path");
		other = new Room("name", false);
		other.setId(1L);
		other.setMapFilePath("path");
	}

	@Test
	public void equalsThis() {
		assertThat(room.equals(room)).isTrue();
	}

	@Test
	public void equalsOtherClass() {
		assertThat(room.equals(new User())).isFalse();
	}

	@Test
	public void equalsRoomThisIdNull() {
		room.setId(null);
		assertThat(room.equals(other)).isFalse();
	}

	@Test
	public void equalsRoomOtherIdNull() {
		room.setId(null);
		other.setId(null);
		assertThat(room.equals(other)).isTrue();
	}

	@Test
	public void equalsRoomOtherIdNotEquals() {
		other.setId(2L);
		assertThat(room.equals(other)).isFalse();
	}

	@Test
	public void equalsRoomThisNameNull() {
		room.setName(null);
		assertThat(room.equals(other)).isFalse();
	}

	@Test
	public void equalsRoomOtherNameNull() {
		room.setName(null);
		other.setName(null);
		assertThat(room.equals(other)).isTrue();
	}

	@Test
	public void equalsRoomOtherNameNotEqual() {
		other.setName("null");
		assertThat(room.equals(other)).isFalse();
	}

	@Test
	public void equalsRoomThisMapFilePathNull() {
		room.setMapFilePath(null);
		assertThat(room.equals(other)).isFalse();
	}

	@Test
	public void equalsRoomOtherMapFilePathNull() {
		room.setMapFilePath(null);
		other.setMapFilePath(null);
		assertThat(room.equals(other)).isTrue();
	}

	@Test
	public void equalsRoomOtherMapFilePathNotEqual() {
		other.setMapFilePath("null");
		assertThat(room.equals(other)).isFalse();
	}

	@Test
	public void equalsRoomThisPlaceholderNull() {
		room.setPlaceholder(null);
		assertThat(room.equals(other)).isFalse();
	}

	@Test
	public void equalsRoomOtherPlaceholderNull() {
		room.setPlaceholder(null);
		other.setPlaceholder(null);
		assertThat(room.equals(other)).isTrue();
	}

	@Test
	public void equalsRoomOtherPlaceholderNotEqual() {
		other.setPlaceholder(true);
		assertThat(room.equals(other)).isFalse();
	}

	@Test
	public void equalsRoomOther() {
		assertThat(room.equals(other)).isTrue();
	}

	@Test
	public void hashCodeNonNull() {
		assertThat(room.hashCode()).isEqualTo(-926126813);
	}

	@Test
	public void hashCodeIdNull() {
		room.setId(null);
		assertThat(room.hashCode()).isEqualTo(-917500895);
	}

	@Test
	public void hashCodeNameNull() {
		room.setName(null);
		assertThat(room.hashCode()).isEqualTo(215050691);
	}

	@Test
	public void hashCodeMapFilePathNull() {
		room.setMapFilePath(null);
		assertThat(room.hashCode()).isEqualTo(-1128701307);
	}

	@Test
	public void hashCodePlaceholderNull() {
		room.setPlaceholder(null);
		assertThat(room.hashCode()).isEqualTo(-926128007);
	}
}
