/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.service;

import static org.assertj.core.api.Assertions.assertThat;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

import nl.tudelft.ewi.queue.QueueApplication;
import nl.tudelft.ewi.queue.model.CommunicationMethod;
import nl.tudelft.ewi.queue.model.Lab;
import nl.tudelft.ewi.queue.model.Request;
import nl.tudelft.ewi.queue.model.User;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.web.WebAppConfiguration;

@SpringBootTest(classes = QueueApplication.class)
@WebAppConfiguration
@AutoConfigureMockMvc
@DirtiesContext(classMode = DirtiesContext.ClassMode.BEFORE_CLASS)
public class JitsiServiceTest {

	@Value("${queue.jitsi.url}")
	private String jitsiURL;

	@Value("${queue.jitsi.protocol}")
	private String jitsiProtocol;

	@Autowired
	private JitsiService jitsiService;

	@Test
	public void getLink() {
		Lab lab = new Lab();
		lab.setCommunicationMethod(CommunicationMethod.JITSI_MEET);

		Request request = new Request();
		request.setLab(lab);
		lab.addRequest(request);

		User user = new User();
		user.setDisplayName("person");

		LocalDateTime time = LocalDateTime.now();

		request.setCreatedAt(time);
		request.setRequestEntity(user);

		request.setJitsiRoom();

		String link = jitsiProtocol + "://" + jitsiURL
				+ "/person" + time.format(DateTimeFormatter.ofPattern("ddmmHHMMss"));

		String url = jitsiService.getJitsiRoomUrl(request);

		assertThat(url).isEqualTo(link);
	}

}
