/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.view;

import static org.assertj.core.api.Assertions.assertThat;

import nl.tudelft.ewi.queue.dto.view.LabStatisticsViewDto;
import nl.tudelft.ewi.queue.model.Course;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LabStatisticsViewDtoTest {

	private LabStatisticsViewDto dto, other;

	@BeforeEach
	public void init() {
		dto = new LabStatisticsViewDto(1L, 1L, 1L, 1L, "assignment", "room", 1L, 1L);
		other = new LabStatisticsViewDto(1L, 1L, 1L, 1L, "assignment", "room", 1L, 1L);
	}

	@Test
	public void equalsThis() {
		assertThat(dto.equals(dto)).isTrue();
	}

	@Test
	public void equalsOtherInstance() {
		assertThat(dto.equals(new Course())).isFalse();
	}

	@Test
	public void equalsOther() {
		assertThat(dto.equals(other)).isTrue();
	}

	@Test
	public void equalsThisNumStudentsNull() {
		dto.setNumStudents(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothNumStudentsNull() {
		dto.setNumStudents(null);
		other.setNumStudents(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentNumStudents() {
		dto.setNumStudents(2L);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsThisNumAssistantsNull() {
		dto.setNumAssistants(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothNumAssistantsNull() {
		dto.setNumAssistants(null);
		other.setNumAssistants(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentNumAssistants() {
		dto.setNumAssistants(2L);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsThisNumOpenNull() {
		dto.setNumOpen(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothNumOpenNull() {
		dto.setNumOpen(null);
		other.setNumOpen(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentNumOpen() {
		dto.setNumOpen(2L);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsThisNumHandledNull() {
		dto.setNumHandled(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothNumHandledNull() {
		dto.setNumHandled(null);
		other.setNumHandled(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentNumHandled() {
		dto.setNumHandled(2L);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsThisAssignmentNull() {
		dto.setAssignment(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothAssignmentNull() {
		dto.setAssignment(null);
		other.setAssignment(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentAssignment() {
		dto.setAssignment("");
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsThisRoomNull() {
		dto.setRoom(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothRoomNull() {
		dto.setRoom(null);
		other.setRoom(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentRoom() {
		dto.setRoom("");
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsThisAvgWaitingTimeNull() {
		dto.setAvgWaitingTime(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothAvgWaitingTimeNull() {
		dto.setAvgWaitingTime(null);
		other.setAvgWaitingTime(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentAvgWaitingTime() {
		dto.setAvgWaitingTime(2L);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsThisAvgProcessingTimeNull() {
		dto.setAvgProcessingTime(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothAvgProcessingTimeNull() {
		dto.setAvgProcessingTime(null);
		other.setAvgProcessingTime(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentAvgProcessingTime() {
		dto.setAvgProcessingTime(2L);
		assertThat(dto.equals(other)).isFalse();
	}
}
