/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.view;

import static org.assertj.core.api.Assertions.assertThat;

import java.util.List;

import nl.tudelft.ewi.queue.dto.view.RequestFrequencyViewDto;
import nl.tudelft.ewi.queue.model.Course;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RequestFrequencyViewDtoTest {

	private RequestFrequencyViewDto dto, other;

	@BeforeEach
	public void init() {
		dto = new RequestFrequencyViewDto(List.of(1L), List.of(1L), List.of(1L), List.of(1L));
		other = new RequestFrequencyViewDto(List.of(1L), List.of(1L), List.of(1L), List.of(1L));
	}

	@Test
	public void equalsThis() {
		assertThat(dto.equals(dto)).isTrue();
	}

	@Test
	public void equalsOtherInstance() {
		assertThat(dto.equals(new Course())).isFalse();
	}

	@Test
	public void equalsOther() {
		assertThat(dto.equals(other)).isTrue();
	}

	@Test
	public void equalsThisBucketsNull() {
		dto.setBuckets(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothBucketsNull() {
		dto.setBuckets(null);
		other.setBuckets(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentBuckets() {
		dto.setBuckets(List.of(2L));
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsThisCreatedNull() {
		dto.setCreated(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothCreatedNull() {
		dto.setCreated(null);
		other.setCreated(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentCreated() {
		dto.setCreated(List.of(2L));
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsThisOpenNull() {
		dto.setOpen(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothOpenNull() {
		dto.setOpen(null);
		other.setOpen(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentOpen() {
		dto.setOpen(List.of(2L));
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsThisHandledNull() {
		dto.setHandled(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothHandledNull() {
		dto.setHandled(null);
		other.setHandled(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentHandled() {
		dto.setHandled(List.of(2L));
		assertThat(dto.equals(other)).isFalse();
	}
}
