/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.view;

import static org.assertj.core.api.Assertions.assertThat;

import nl.tudelft.ewi.queue.dto.view.RequestStatusViewDto;
import nl.tudelft.ewi.queue.model.Course;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RequestStatusViewDtoTest {

	private RequestStatusViewDto dto, other;

	@BeforeEach
	public void init() {
		dto = new RequestStatusViewDto(1L, 1L, 1L, 1L, 1L, 1L);
		other = new RequestStatusViewDto(1L, 1L, 1L, 1L, 1L, 1L);
	}

	@Test
	public void equalsThis() {
		assertThat(dto.equals(dto)).isTrue();
	}

	@Test
	public void equalsOtherInstance() {
		assertThat(dto.equals(new Course())).isFalse();
	}

	@Test
	public void equalsOther() {
		assertThat(dto.equals(other)).isTrue();
	}

	@Test
	public void equalsThisPendingNull() {
		dto.setPending(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothPendingNull() {
		dto.setPending(null);
		other.setPending(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentPending() {
		dto.setPending(2L);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsThisProcessingNull() {
		dto.setProcessing(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothProcessingNull() {
		dto.setProcessing(null);
		other.setProcessing(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentProcessing() {
		dto.setProcessing(2L);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsThisApprovedNull() {
		dto.setApproved(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothApprovedNull() {
		dto.setApproved(null);
		other.setApproved(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentApproved() {
		dto.setApproved(2L);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsThisRejectedNull() {
		dto.setRejected(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothRejectedNull() {
		dto.setRejected(null);
		other.setRejected(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentRejected() {
		dto.setRejected(2L);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsThisNotFoundNull() {
		dto.setNotFound(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothNotFoundNull() {
		dto.setNotFound(null);
		other.setNotFound(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentNotFound() {
		dto.setNotFound(2L);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsThisRevokedNull() {
		dto.setRevoked(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothRevokedNull() {
		dto.setRevoked(null);
		other.setRevoked(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentRevoked() {
		dto.setRevoked(2L);
		assertThat(dto.equals(other)).isFalse();
	}
}
