/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.ewi.queue.view;

import static org.assertj.core.api.Assertions.assertThat;

import nl.tudelft.ewi.queue.dto.view.RoomMapPathDTO;
import nl.tudelft.ewi.queue.model.Course;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RoomMapPathDtoTest {

	private RoomMapPathDTO dto, other;

	@BeforeEach
	public void init() {
		dto = new RoomMapPathDTO("path");
		other = new RoomMapPathDTO("path");
	}

	@Test
	public void equalsThis() {
		assertThat(dto.equals(dto)).isTrue();
	}

	@Test
	public void equalsOtherInstance() {
		assertThat(dto.equals(new Course())).isFalse();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsOther() {
		assertThat(dto.equals(other)).isTrue();
	}

	@Test
	public void equalsThisPathNull() {
		dto.setPath(null);
		assertThat(dto.equals(other)).isFalse();
	}

	@Test
	public void equalsBothPathNull() {
		dto.setPath(null);
		other.setPath(null);
		assertThat(dto.equals(other)).isTrue();
		assertThat(dto.hashCode()).isEqualTo(other.hashCode());
	}

	@Test
	public void equalsDifferentPath() {
		dto.setPath("");
		assertThat(dto.equals(other)).isFalse();
	}
}
