/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.cache;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import nl.tudelft.labracore.api.StudentGroupControllerApi;
import nl.tudelft.labracore.api.dto.RolePersonLayer1DTO;
import nl.tudelft.labracore.api.dto.StudentGroupDetailsDTO;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@Component
@RequestScope
public class StudentGroupCacheManager extends CoreCacheManager<Long, StudentGroupDetailsDTO> {
	@Autowired
	private StudentGroupControllerApi api;

	@Autowired
	private PersonCacheManager pCache;

	@Override
	protected List<StudentGroupDetailsDTO> fetch(List<Long> ids) {
		return api.getStudentGroupsById(ids).collectList().block();
	}

	@Override
	protected Long getId(StudentGroupDetailsDTO dto) {
		return dto.getId();
	}

	@Override
	protected void registerAdditionally(StudentGroupDetailsDTO dto) {
		pCache.register(Objects.requireNonNull(dto.getMembers()).stream()
				.map(RolePersonLayer1DTO::getPerson).collect(Collectors.toList()));
	}
}
