/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.config;

import nl.tudelft.librador.EnableLibrador;
import nl.tudelft.librador.dto.id.IdMapperBuilder;
import nl.tudelft.queue.dto.id.*;
import nl.tudelft.queue.model.ClosableTimeSlot;
import nl.tudelft.queue.model.Lab;
import nl.tudelft.queue.model.Request;
import nl.tudelft.queue.model.TimeSlot;
import nl.tudelft.queue.model.labs.ExamLab;
import nl.tudelft.queue.model.labs.RegularLab;
import nl.tudelft.queue.model.labs.SlottedLab;

import org.modelmapper.ModelMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableLibrador
@Configuration
public class LibradorConfig {
	/**
	 * Bean for the {@link IdMapperBuilder} that is used by Librador to create proper conversions within the
	 * used {@link org.modelmapper.ModelMapper}.
	 *
	 * @return The {@link IdMapperBuilder} with all ID DTOs registered.
	 */
	@Bean
	public IdMapperBuilder idMapperBuilder() {
		IdMapperBuilder builder = new IdMapperBuilder();

		builder.register(LabIdDTO.class, Lab.class);
		builder.register(RegularLabIdDTO.class, RegularLab.class);
		builder.register(SlottedLabIdDTO.class, SlottedLab.class);
		builder.register(ExamLabIdDTO.class, ExamLab.class);
		builder.register(RequestIdDTO.class, Request.class);
		builder.register(ClosableTimeSlotIdDTO.class, ClosableTimeSlot.class);
		builder.register(TimeSlotIdDTO.class, TimeSlot.class);

		return builder;
	}

	@Bean
	public ModelMapper modelMapper() {
		return idMapperBuilder().build();
	}
}
