/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.dto.patch;

import java.util.*;

import lombok.*;
import lombok.experimental.SuperBuilder;
import nl.tudelft.librador.dto.patch.Patch;
import nl.tudelft.queue.model.Lab;
import nl.tudelft.queue.model.embeddables.Slot;
import nl.tudelft.queue.model.enums.CommunicationMethod;
import nl.tudelft.queue.model.enums.RequestType;

@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
public abstract class LabPatchDTO<D extends Lab> extends Patch<D> {
	private String name;
	private Slot slot;
	private CommunicationMethod communicationMethod;

	private Set<Long> modules = new HashSet<>();
	private Map<Long, Set<RequestType>> requestTypes = new HashMap<>();

	private Set<Long> rooms = new HashSet<>();

	@Override
	protected void applyOneToOne() {
		updateNonNull(communicationMethod, data::setCommunicationMethod);
	}

	@Override
	protected void applyManyToManyDominant() {
		updateNonNull(modules, data::setModules);
		updateNonNull(requestTypes, data::setAllowedRequestsFromMap);
	}

	@Override
	protected void validate() {
		nonEmpty("modules", modules);
		nonEmpty("requestTypes", requestTypes);
		nonEmpty("rooms", rooms);
	}

	private void nonEmpty(String field, Collection<?> set) {
		if (set != null && set.isEmpty()) {
			errors.rejectValue(field, "Field should not be empty");
		}
	}

	private void nonEmpty(String field, Map<?, ?> set) {
		if (set != null && set.isEmpty()) {
			errors.rejectValue(field, "Field should not be empty");
		}
	}
}
