/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.model.embeddables;

import java.time.LocalDateTime;

import javax.persistence.Embeddable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import org.springframework.format.annotation.DateTimeFormat;

@Data
@Builder
@Embeddable
@NoArgsConstructor
@AllArgsConstructor
public class SlottedLabConfig {
	private static final String TIME_FORMAT = "dd/MM/yyyy HH:mm";

	/**
	 * The time that should be assigned to each of the timeslots. The slot duration is stored in minutes.
	 */
	@NotNull
	@Min(value = 1L, message = "Interval time must be positive")
	private Long duration;

	/**
	 * The number of groups that can enrol for one particular time slot before all spots are taken.
	 */
	@NotNull
	@Min(value = 1L, message = "Capacity must be positive")
	private Integer capacity;

	/**
	 * The time starting which a slot can be selected and requests can be made for this slot lab.
	 */
	@NotNull
	@DateTimeFormat(pattern = TIME_FORMAT)
	private LocalDateTime selectionOpensAt;

}
