/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.model.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import nl.tudelft.queue.dto.create.LabCreateDTO;
import nl.tudelft.queue.dto.create.labs.ExamLabCreateDTO;
import nl.tudelft.queue.dto.create.labs.RegularLabCreateDTO;
import nl.tudelft.queue.dto.create.labs.SlottedLabCreateDTO;

@Getter
@AllArgsConstructor
public enum LabType {
	REGULAR(
		"Regular"
	),
	SLOTTED(
		"Slotted"
	),
	EXAM(
		"Exam"
	);

	/**
	 * The name of the type of lab to display to students and assistants.
	 */
	private final String displayName;

	/**
	 * @return A newly constructed instance of a {@link LabCreateDTO} subclass depending on the type of the
	 *         lab.
	 */
	public LabCreateDTO<?> newCreateDto() {
		switch (this) {
			case SLOTTED:
				return new SlottedLabCreateDTO();
			case EXAM:
				return new ExamLabCreateDTO();
			default:
				return new RegularLabCreateDTO();
		}
	}
}
