/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.model.events;

import static nl.tudelft.queue.model.enums.RequestStatus.APPROVED;

import javax.persistence.Entity;
import javax.validation.constraints.NotNull;

import lombok.NoArgsConstructor;
import nl.tudelft.librador.dto.view.View;
import nl.tudelft.queue.dto.view.events.RequestApprovedEventViewDTO;
import nl.tudelft.queue.model.Request;
import nl.tudelft.queue.model.enums.RequestStatus;

@Entity
@NoArgsConstructor
public class RequestApprovedEvent extends RequestHandledEvent {
	public RequestApprovedEvent(Request request, @NotNull Long assistant, String reasonForAssistant) {
		super(request, assistant, reasonForAssistant, null);
	}

	@Override
	public RequestStatus status() {
		return APPROVED;
	}

	@Override
	public RequestApprovedEventViewDTO viewDTO() {
		return View.convert(this, RequestApprovedEventViewDTO.class);
	}
}
