/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.realtime.messages;

import lombok.*;
import nl.tudelft.labracore.api.dto.RoomSummaryDTO;
import nl.tudelft.librador.dto.view.View;
import nl.tudelft.queue.dto.view.RequestViewDTO;
import nl.tudelft.queue.model.Request;
import nl.tudelft.queue.model.enums.RequestStatus;
import nl.tudelft.queue.model.enums.RequestType;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class RequestCreatedMessage extends View<Request> implements Message {
	private static final long serialVersionUID = -3558345410667448241L;

	private Long id;
	private String sentence;
	private String organizationName;
	private RoomSummaryDTO room;

	private Long labId;
	private Long assignment;
	private RequestStatus status;
	private RequestType requestType;

	@Override
	public String getType() {
		return "request-created";
	}

	@Override
	public void postApply() {
		RequestViewDTO view = View.convert(data, RequestViewDTO.class);

		sentence = view.toSentence();
		organizationName = view.organizationName();
		room = view.getRoom();

		labId = view.getLab().getId();
		status = RequestStatus.PENDING;
	}
}
