/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.repository;

import java.util.Optional;

import nl.tudelft.queue.model.Feedback;
import nl.tudelft.queue.model.QFeedback;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.CrudRepository;

public interface FeedbackRepository
		extends CrudRepository<Feedback, Feedback.Id>, QuerydslPredicateExecutor<Feedback> {
	QFeedback qf = QFeedback.feedback1;

	/**
	 * @param  requestId   The id of the request to lookup feedback for.
	 * @param  assistantId The id of the assistant to lookup feedback for.
	 * @return             The feedback given to the given assistant on the given request if one exists or
	 *                     none if one cannot be found.
	 */
	default Optional<Feedback> findById(Long requestId, Long assistantId) {
		return findById(new Feedback.Id(requestId, assistantId));
	}

	/**
	 * @param  assistantId The assistant to find Feedback for.
	 * @param  pageable    The pageable object to page feedback with.
	 * @return             The page of feedback for the given Assistant.
	 */
	default Page<Feedback> findByAssistant(Long assistantId, Pageable pageable) {
		return findAll(qf.id.assistantId.eq(assistantId), pageable);
	}
}
