/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.repository;

import java.util.List;

import nl.tudelft.queue.model.Lab;
import nl.tudelft.queue.model.QLab;
import nl.tudelft.queue.model.labs.QExamLab;
import nl.tudelft.queue.model.labs.QRegularLab;
import nl.tudelft.queue.model.labs.QSlottedLab;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.lang.NonNull;

import com.querydsl.core.types.Predicate;

public interface LabRepository extends JpaRepository<Lab, Long>, QuerydslPredicateExecutor<Lab> {
	QLab ql = QLab.lab;

	QRegularLab qrl = QRegularLab.regularLab;
	QSlottedLab qsl = QSlottedLab.slottedLab;
	QExamLab qel = QExamLab.examLab;

	@NonNull
	@Override
	List<Lab> findAll(@NonNull Predicate predicate);

	/**
	 * @param  sessions The ids of the sessions to find labs for.
	 * @return          The labs that are in the given sessions.
	 */
	default List<Lab> findAllBySessions(List<Long> sessions) {
		return findAll(ql.session.in(sessions));
	}

}
