/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.security;

import nl.tudelft.labracore.lib.security.LabradorSecurityConfigurerAdapter;

import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;

@Configuration
@Profile("production")
@EnableWebSecurity
public class ProductionSecurityConfig extends LabradorSecurityConfigurerAdapter {
	@Override
	protected void configure(HttpSecurity http) throws Exception {
		super.configure(http);

		//@formatter:off
		http
				.authorizeRequests()
					.antMatchers("/").permitAll()
					.antMatchers("/manifest.json").permitAll()
					.antMatchers("/favicon.ico").permitAll()
					.antMatchers("/sw.js").permitAll()
					.antMatchers("/css/**").permitAll()
					.antMatchers("/sass/**").permitAll()
					.antMatchers("/img/**").permitAll()
					.antMatchers("/js/**").permitAll()
					.antMatchers("/webjars/**").permitAll()
					.antMatchers("/stomp/**").permitAll()
					.antMatchers("/lab/submit*").permitAll()
					.antMatchers("/privacy").permitAll()
					.antMatchers("/about").permitAll()
				.anyRequest()
					.authenticated();

		http.exceptionHandling().accessDeniedPage("/error");
		//@formatter:on
	}
}
