/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.service;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import nl.tudelft.labracore.api.dto.PersonSummaryDTO;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class EditionService {

	/**
	 * Filters a list of people on their username, display name and student number. If any of the
	 * aforementioned values match the given search term, the person is included. If not, the person is
	 * excluded.
	 *
	 * @param  people     The people through which we need to filter.
	 * @param  searchTerm The original search term that was typed by the user.
	 * @return            The filtered list of people (this could be empty).
	 */
	public List<PersonSummaryDTO> studentsMatchingFilter(List<PersonSummaryDTO> people,
			String searchTerm) {
		var search = searchTerm.toLowerCase();

		return people.stream()
				.filter(person -> person.getDisplayName() != null
						&& StringUtils.stripAccents(person.getDisplayName())
								.toLowerCase().contains(search)
						||
						person.getUsername() != null && StringUtils.stripAccents(person.getUsername())
								.toLowerCase().contains(search)
						||
						Objects.toString(person.getNumber()).contains(search))
				.collect(Collectors.toList());
	}
}
