/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
$(() => {
    $("#inputRoom").change(() => {
        // Get the room ID of the currently selected room.
        const roomId = $("#inputRoom").find(":selected").attr("value");
        updateRequestInfo(roomId);
    });
});

function updateRequestInfo(roomId) {
    $.get({
        url: "/room/map/" + roomId,
        success: function (response) {
            if (response.path === undefined || response.path === null) {
                this.error();
                return;
            }
            const image = $('<img class="img-fluid" alt="Room map">');
            image.attr("src", "/" + response.path);

            $("#image-holder").show().html(image);
            $("#inputLocation").prop("disabled", false);
        },
        error: function() {
            $("#image-holder").hide();
            $("#inputLocation").prop("disabled", true);
        }
    });
}
