/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.application;

import nl.tudelft.queue.DevQueueApplication;
import nl.tudelft.queue.TestQueueApplication;

import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;

public class SmokeTest {
	static abstract class TestClass {
		@Test
		public void smoke() {
		}
	}

	@Nested
	@SpringBootTest(classes = DevQueueApplication.class)
	@DirtiesContext(classMode = DirtiesContext.ClassMode.BEFORE_CLASS)
	public class DevelopmentApplicationWithValidateTest extends TestClass {
	}

	@Nested
	@SpringBootTest(classes = TestQueueApplication.class)
	@DirtiesContext(classMode = DirtiesContext.ClassMode.BEFORE_CLASS)
	public class TestApplicationTest extends TestClass {
	}
}
