/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.controller;

import static org.mockito.ArgumentMatchers.*;
import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.model;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.time.LocalDateTime;
import java.util.List;

import javax.transaction.Transactional;

import nl.tudelft.labracore.api.EditionControllerApi;
import nl.tudelft.labracore.api.dto.EditionDetailsDTO;
import nl.tudelft.labracore.api.dto.EditionSummaryDTO;
import nl.tudelft.labracore.api.dto.SessionSummaryDTO;
import nl.tudelft.queue.TestQueueApplication;
import nl.tudelft.queue.cache.EditionCacheManager;
import nl.tudelft.queue.service.PermissionService;

import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.security.test.context.support.WithUserDetails;
import org.springframework.test.web.servlet.MockMvc;

import reactor.core.publisher.Flux;

@Transactional
@AutoConfigureMockMvc
@SpringBootTest(classes = TestQueueApplication.class)
public class AdminControllerTest {
	@Autowired
	private EditionCacheManager eCache;

	@Autowired
	private EditionControllerApi eApi;

	@MockBean
	private PermissionService ps;

	@Autowired
	private MockMvc mockMvc;

	private static final SessionSummaryDTO session1 = new SessionSummaryDTO().id(1L)
			.start(LocalDateTime.now().minusHours(1)).end(LocalDateTime.now().plusDays(1));

	private static final EditionSummaryDTO editionSummary1 = new EditionSummaryDTO().id(1L);

	private static final EditionDetailsDTO edition1 = new EditionDetailsDTO().sessions(List.of(session1));

	@Test
	@WithUserDetails("admin1")
	void getAdminPanel() throws Exception {
		when(eApi.getAllEditionsActiveDuringPeriod(any())).thenReturn(Flux.just(editionSummary1));
		when(eCache.get(ArgumentMatchers.<Long>anyList())).thenReturn(List.of(edition1));
		doReturn(true).when(ps).isAdmin();

		mockMvc.perform(get("/admin")).andExpect(status().isOk()).andExpect(model().attribute(
				"warningMessage", "Currently 1 sessions ongoing!")).andExpect(model().attribute(
						"sessions", List.of(session1)));
	}
}
