/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.model;

import static org.assertj.core.api.Assertions.assertThat;

import java.util.Set;

import nl.tudelft.queue.model.embeddables.RequestEventInfo;
import nl.tudelft.queue.model.enums.RequestStatus;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TimeSlotTest {

	private TimeSlot timeSlot1;
	private TimeSlot timeSlot2;
	private TimeSlot timeSlot3;

	private Request request1;
	private Request request2;
	private Request request3;

	private Lab lab1;
	private Lab lab2;

	@BeforeEach
	void setUp() {
		request1 = Request.builder()
				.eventInfo(RequestEventInfo.builder()
						.status(RequestStatus.REVOKED)
						.build())
				.build();

		request2 = Request.builder()
				.eventInfo(RequestEventInfo.builder()
						.status(RequestStatus.PENDING)
						.build())
				.build();

		request3 = Request.builder()
				.eventInfo(RequestEventInfo.builder()
						.status(RequestStatus.REJECTED)
						.build())
				.build();

		timeSlot1 = new TimeSlot();
		timeSlot1.setCapacity(2);
		timeSlot1.setRequests(Set.of(request1, request2, request3));

		timeSlot2 = new TimeSlot();
		timeSlot2.setCapacity(3);
		timeSlot2.setRequests(Set.of(request1, request2, request3));

		timeSlot3 = new TimeSlot();
		timeSlot3.setCapacity(3);
		timeSlot3.setRequests(Set.of(request1));
	}

	@Test
	void countSlotsTakenDoesNotIncludeRevoked() {
		assertThat(timeSlot3.countSlotsOccupied())
				.isEqualTo(0);
	}

	@Test
	void countSlotsTakenDoesIncludeOtherRequestStatuses() {
		assertThat(timeSlot1.countSlotsOccupied())
				.isEqualTo(2);
	}

	@Test
	void isFullChecksAgainstCapacityNegative() {
		assertThat(timeSlot1.isFull()).isTrue();
	}

	@Test
	void isFullChecksAgainstCapacityPositive() {
		assertThat(timeSlot2.isFull()).isFalse();
	}
}
