/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.service;

import static org.assertj.core.api.Assertions.assertThat;

import java.util.List;

import nl.tudelft.labracore.api.dto.PersonSummaryDTO;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EditionServiceTest {

	private EditionService es;

	private PersonSummaryDTO person1;
	private PersonSummaryDTO person2;
	private PersonSummaryDTO person3;
	private PersonSummaryDTO person4;
	private PersonSummaryDTO person5;

	private List<PersonSummaryDTO> people;

	@BeforeEach
	void setUp() {
		es = new EditionService();

		person1 = new PersonSummaryDTO()
				.displayName("Christopher Columbus")
				.number(345)
				.username("cruv");
		person2 = new PersonSummaryDTO()
				.displayName("Rubenov Maliciious")
				.number(6482)
				.username("rmaliciious");
		person3 = new PersonSummaryDTO()
				.displayName("Sarin Justice")
				.number(618)
				.username("hippo5");
		person4 = new PersonSummaryDTO()
				.displayName("Karen McKarenVille")
				.number(42)
				.username("karen42");
		person5 = new PersonSummaryDTO()
				.displayName("Ottomano Coronu")
				.number(55)
				.username("maninthecorona");

		people = List.of(person1, person2, person3, person4, person5);
	}

	@Test
	void studentsMatchingFilterChecksDisplayName() {
		assertThat(es.studentsMatchingFilter(people, "en"))
				.containsExactly(person2, person4);
	}

	@Test
	void studentsMatchingFilterChecksStudentNumber() {
		assertThat(es.studentsMatchingFilter(people, "5"))
				.containsExactly(person1, person3, person5);
	}

	@Test
	void studentsMatchingFilterChecksUsername() {
		assertThat(es.studentsMatchingFilter(people, "p"))
				.containsExactly(person1, person3);
	}
}
